unit Unit1;

interface
{==============================================================================}
{ Demo: how to load RVF file saved in demo editor.                             }
{ Sergey Tkachenko                                                             }
{------------------------------------------------------------------------------}
{ Providing pictures and controls on request from RichView is not supported in }
{ this demo.                                                                   }                                                 
{==============================================================================}

{$I RV_Defs.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  {$IFDEF RICHVIEWDEF4}
  ImgList,
  {$ENDIF}
  RVScroll, RichView, StdCtrls, ExtCtrls, RVStyle, OleCtnrs, RVTable,
  SclRView;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    Panel1: TPanel;
    RVStyle1: TRVStyle;
    ImageList1: TImageList;
    Button1: TButton;
    srv: TSRichViewEdit;
    procedure Button1Click(Sender: TObject);
    procedure RichView1RVFImageListNeeded(Sender: TCustomRichView;
      ImageListTag: Integer; var il: TCustomImageList);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{
Notes about loading from RVF files:
1. In simplest cases you can just write: srv.RichViewEdit.LoadRVF(<file name>);
2. If file contains inserted Delphi Controls, these controls must be registered
   with RegisterClasses functions before loading (see FormCreate below)
3. If file contains images from image lists, you need to process
   OnRVFImageListNeeded event (see RichView1RVFImageListNeeded below)
   If you have several image lists, you can distinguish them using
   ImageListTag parameter of this event.
4. You must have the same (or compatible) TRVStyle object assigned to
   srv.RichViewEdit.Style as in editor.
   Otherwise, you need to set option "Allow adding styles dynamically"
   both in richview which saves and in richview which loads RVF
   (right-click RichView in Delphi, choose "Settings" in the context menu)
5. If some items in RVF file have character strings associated as items' tags
   (rvoTagsArePChars was in editor's Options), you need also set rvoTagsArePChars
   in srv.RichViewEdit.Options.
}


procedure TForm1.FormCreate(Sender: TObject);
begin
  RegisterClasses([TButton, TEdit, TOleContainer]);
end;


procedure TForm1.Button1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then begin
    // Clearing and deleting unused text styles.
    // If RVF contains collections of styles, it is not necessary,
    // because collections from the file will replace the existing collections
    srv.RichViewEdit.Clear;
    srv.RichViewEdit.DeleteUnusedStyles(True, True, True);
    // Resetting background.
    // If RVF contains background information and rvfoLoadBack is in RVFOptions,
    // it is not necessary
    srv.RichViewEdit.BackgroundBitmap := nil;
    // Loading
    if not srv.RichViewEdit.LoadRVF(OpenDialog1.FileName) then
      Application.MessageBox('Error Loading File', nil, MB_OK);
    // Formatting (necessary before displaying)
    srv.RichViewEdit.Format;
    srv.SetRVMargins;
  end;
end;

procedure TForm1.RichView1RVFImageListNeeded(Sender: TCustomRichView;
  ImageListTag: Integer; var il: TCustomImageList);
begin
  il := ImageList1;
end;

end.
